#!/bin/sh
GBL_OS_TYPE_ERROR=0
GBL_OS_TYPE_UKNOWN=1
GBL_OS_TYPE_SLES11=4
GBL_OS_TYPE_RHEL6=5
GBL_OS_TYPE_RHEL7=6
GBL_OS_TYPE_SLES12=7
GBL_OS_TYPE_SLES15=9

GBL_OS_TYPE_STRING=$GBL_OS_TYPE_UKNOWN
ARCH="x86_64"
status=0
TRUE=0
FALSE=1

#############
## IsHigherGeneration()
## Compares the system ID with the lowest 12G systemID (0x48C)
## If higher than 0x48C, then return 0
#############
IsHigherGeneration() 
{
    SYSID_STR=`dmidecode -t 208 | tail -3 | sed '2q;d'`
	SYSID_STR=`echo ${SYSID_STR:28:3}${SYSID_STR:25:3}`
	SYSID_HEX=`echo 0x${SYSID_STR//[[:blank:]]/}`
    SYSID_DEC=`printf "%d"  $SYSID_HEX`
    MIN_SUPPORTED_SYSID_HEX=0x048C
    MIN_SUPPORTED_SYSID_DEC=`printf "%d" $MIN_SUPPORTED_SYSID_HEX`

    if [ $SYSID_DEC -ge $MIN_SUPPORTED_SYSID_DEC ]; then
       # Supported Generation.
       return $TRUE
    else
       return $FALSE
    fi
}

#function to check supported operating system.
GetOSType()
{
    # check if operating system is RHEL6.
    if [ -f /etc/redhat-release ] && [ `grep -Eci "Santiago|CentOs.* 6\..*" /etc/redhat-release` -gt 0 ]; then
	GBL_OS_TYPE=${GBL_OS_TYPE_RHEL6}
        GBL_OS_TYPE_STRING="RHEL6"
    elif [ -f /etc/redhat-release ] && [ `grep -Eci "Maipo|CentOs.* 7\..*" /etc/redhat-release` -gt 0 ]; then
	GBL_OS_TYPE=${GBL_OS_TYPE_RHEL7}
        GBL_OS_TYPE_STRING="RHEL7"
    elif [ -f /etc/SuSE-release ]; then
        LOC_VERSION=`cat /etc/SuSE-release | grep "VERSION" | sed  -e 's#[^0-9]##g'`
        # Check if operating system is SLES11.
        if [ "${LOC_VERSION}" = "11" ]; then
		GBL_OS_TYPE=${GBL_OS_TYPE_SLES11}
                GBL_OS_TYPE_STRING="SLES11"
	# else operating system is SLES12.
        elif [ "${LOC_VERSION}" = "12" ]; then
		GBL_OS_TYPE=${GBL_OS_TYPE_SLES12}
                GBL_OS_TYPE_STRING="SLES12"
        fi
    elif [ -f /etc/os-release ]; then
	# check if operating system is SLES15		
	. /etc/os-release
	OS=$NAME
	VER=`echo $VERSION_ID | cut -d"." -f1`
        if [ "$OS" == "SLES" ] && [ "$VER" == "15" ]; then
		GBL_OS_TYPE=${GBL_OS_TYPE_SLES15}
		GBL_OS_TYPE_STRING="SLES15"
	fi		
    fi

    return 0
}

function setPath()
{
if [ $status -eq 0 ]; then
echo "     **********************************************************"
echo "     After the install process completes, you may need "
echo "     to logout and then login again to reset the PATH"
echo "     variable to access the RACADM CLI utilities"
echo ""
echo "     **********************************************************"
fi
echo $PATH | tr ";" "\n" | grep "/opt/dell/srvadmin/bin" >/dev/null
if [ $? -eq 1 ]; then
	if [ "$GBL_OS_TYPE_STRING" == "RHEL6" ] || [ "$GBL_OS_TYPE_STRING" == "RHEL7" ]; then
		echo "PATH=$PATH:/opt/dell/srvadmin/sbin" >> /etc/bashrc
	else
		echo "PATH=$PATH:/opt/dell/srvadmin/sbin" >> /etc/bash.bashrc
	fi
fi
}

#function to install/upgrade IR rpm's
function InstallPkgs()
{
#	IsHigherGeneration
#	if [ $? -eq $FALSE ]; then
#		echo "This RACADM installer is not supported on 11G and below generation of servers."    
#		exit
#	fi

	GetOSType
	if [ "${GBL_OS_TYPE}" = "${GBL_OS_TYPE_UKNOWN}" ] || [ "${GBL_OS_TYPE}" = "${GBL_OS_TYPE_ERROR}" ] || [ $ARCH != "x86_64" ]; 	    then
		echo "Unsupported Operating System or Architecture."    
		exit
	fi
	#check if OMSA is installed
	rpm -q srvadmin-omilcore >/dev/null
	if [ $? -eq 0 ]; then
		OMSA_INSTALLED_VER=`rpm -q --queryformat "%{VERSION}" srvadmin-omilcore`
		OMSA_INSTALLED_VER=`echo "${OMSA_INSTALLED_VER}" | sed "s/\.//g" | sed "s/-//g" | sed "s/ //g"`
		IR_NEW_VER=`rpm -qp --queryformat "%{VERSION}" $GBL_OS_TYPE_STRING/$ARCH/srvadmin-idracadm7*.rpm 2>/dev/null`
		IR_NEW_VER=`echo "${IR_NEW_VER}" | sed "s/\.//g" | sed "s/-//g" | sed "s/ //g"`
		if [ ${OMSA_INSTALLED_VER} -lt ${IR_NEW_VER} ]; then
			rpm -Fvh $GBL_OS_TYPE_STRING/$ARCH/srvadmin-idracadm7*.rpm --nodeps
		elif [ ${IR_NEW_VER} -lt ${OMSA_INSTALLED_VER} ]; then
			echo "Cannot install Racadm as it is lower than OMSA version."
            status=1
		elif [ ${OMSA_INSTALLED_VER} == ${IR_NEW_VER} ]; then
			rpm -q srvadmin-idracadm7 >/dev/null
			if [ $? -ne 0 ]; then
				pushd $GBL_OS_TYPE_STRING/$ARCH/ >/dev/null
				rpm -ivh srvadmin-argtable2*.rpm srvadmin-hapi*.rpm srvadmin-idracadm7*.rpm
				popd >/dev/null
			else
				echo "Racadm is already running on the latest version."
                status=1
			fi
		fi
	else
	rpm -q srvadmin-idracadm7 >/dev/null
	if [ $? -eq 0 ]; then
		IR_INSTALLED_VER=`rpm -q --queryformat "%{VERSION}" srvadmin-idracadm7`
		IR_INSTALLED_VER=`echo "${IR_INSTALLED_VER}" | sed "s/\.//g" | sed "s/-//g" | sed "s/ //g"`
		IR_NEW_VER=`rpm -qp --queryformat "%{VERSION}" $GBL_OS_TYPE_STRING/$ARCH/srvadmin-idracadm7*.rpm 2>/dev/null`
		IR_NEW_VER=`echo "${IR_NEW_VER}" | sed "s/\.//g" | sed "s/-//g" | sed "s/ //g"`
		if [ ${IR_INSTALLED_VER} -lt ${IR_NEW_VER} ]; then
		    pushd $GBL_OS_TYPE_STRING/$ARCH/ >/dev/null
		    rpm -Uvh srvadmin-argtable2*.rpm srvadmin-hapi*.rpm srvadmin-idracadm7*.rpm
		    popd >/dev/null
		elif [ ${IR_INSTALLED_VER} == ${IR_NEW_VER} ]; then
				echo "Racadm is already running on the latest version."
                status=1
        fi
    else
		pushd $GBL_OS_TYPE_STRING/$ARCH/ >/dev/null
		rpm -ivh srvadmin-argtable2*.rpm srvadmin-hapi*.rpm srvadmin-idracadm7*.rpm
		popd >/dev/null
    fi
	fi
}
InstallPkgs
setPath
